<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/db.php';

if (!isset($_SESSION['memberId'])) {
    header("Location: home");
    exit;
}

$user_id = $_SESSION['memberId'];
$userCheckSite = $DB->prepare("SELECT * FROM users WHERE id = ?");
$userCheckSite->execute(array($user_id));
$userChk = $userCheckSite->fetch(PDO::FETCH_ASSOC);

$search = isset($_POST['search']) ? $_POST['search'] : '';


$orderQuery = $DB->prepare("SELECT orders.*, GROUP_CONCAT(products.ad SEPARATOR ', ') AS product_names
                            FROM orders
                            LEFT JOIN products ON FIND_IN_SET(products.id, orders.products)
                            WHERE orders.id LIKE ? OR products.ad LIKE ?
                            GROUP BY orders.id
                            ORDER BY orders.id DESC"); 

$searchTerm = "%{$search}%";
$orderQuery->execute([$searchTerm, $searchTerm]);
$orders = $orderQuery->fetchAll(PDO::FETCH_ASSOC);

?>

<?php foreach ($orders as $orderData): ?>
<tr class="odd">
    <td class="sorting_1">#<?=$orderData['id']?></td>
    <td>
    <h6>
    <?php
        $urunParcala = explode(",", $orderData['products']); 
        $urunSayi = count($urunParcala);
        $i = 0;
        foreach($urunParcala as $urunParcalaCek){
            $urunDetay = $DB->query("SELECT c.ad AS kategori_ad FROM products p INNER JOIN category c ON p.category = c.id WHERE p.id = $urunParcalaCek")->fetch(PDO::FETCH_ASSOC);  
            $i++;
            echo $urunDetay['kategori_ad'];
            if($i != $urunSayi) {
                echo ", ";
            }
        }
    ?>
    </h6>
</td>
    <td>
        <h6><?=$orderData['product_names']?></h6>
    </td>
    <td>
                                        <h6><?php
                                                        $memberID = $orderData['memberID'];
                                                        $musteriDetay = $DB->query("select * from members where id='$memberID'")->fetch(PDO::FETCH_ASSOC);  
                                                        ?>
                                                        <?php echo $musteriDetay['name'];?></h6>
                                        </td>
    <td>
        <h6><?=$orderData['orderFiyat']?>₺</h6>
    </td>
    <td><?=$orderData['orderDate']?></td>
    <td>
        <?php
        $remainingDebt = $orderData['remainingDebt'];
        $debtDisplay = ($remainingDebt < 0) ? substr($remainingDebt, 1) : $remainingDebt;
        $debtColor = ($remainingDebt <= 0) ? 'green' : 'red';
        ?>
        <a style="color:<?=$debtColor?>"><?=$debtDisplay?> ₺</a>
    </td>
    <td>
        <div class="d-flex">
            <?php if ($userChk['porderEdit'] == '1' || $userChk['isAdmin'] == '1') { ?>					
            <a href="order/<?=$orderData['id']?>" class="btn btn-primary shadow btn-xs sharp me-1"><i data-feather="edit-2" class="feather-icon-edit"></i></a>
            <?php } ?>
            <?php if ($userChk['porderDell'] == '1' || $userChk['isAdmin'] == '1') { ?>						
            <a id="orderDell" orderID="<?=$orderData['id']?>" class="orderDell btn btn-danger shadow btn-xs sharp"><i data-feather="trash-2" class="feather-icon-trash"></i></a>
            <?php } ?>		
        </div>
    </td>
</tr>
<?php endforeach; ?>
<script>feather.replace();</script>
